/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.command.AnvilCommands;
import com.boydti.fawe.command.CFICommands;
import com.boydti.fawe.util.StringMan;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.command.BiomeCommands;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.BrushOptionsCommands;
import com.sk89q.worldedit.command.ChunkCommands;
import com.sk89q.worldedit.command.ClipboardCommands;
import com.sk89q.worldedit.command.GenerationCommands;
import com.sk89q.worldedit.command.HistoryCommands;
import com.sk89q.worldedit.command.MaskCommands;
import com.sk89q.worldedit.command.NavigationCommands;
import com.sk89q.worldedit.command.OptionsCommands;
import com.sk89q.worldedit.command.PatternCommands;
import com.sk89q.worldedit.command.RegionCommands;
import com.sk89q.worldedit.command.SchematicCommands;
import com.sk89q.worldedit.command.ScriptingCommands;
import com.sk89q.worldedit.command.SelectionCommands;
import com.sk89q.worldedit.command.SnapshotCommands;
import com.sk89q.worldedit.command.SnapshotUtilCommands;
import com.sk89q.worldedit.command.SuperPickaxeCommands;
import com.sk89q.worldedit.command.ToolCommands;
import com.sk89q.worldedit.command.TransformCommands;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.command.WorldEditCommands;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;

public final class DocumentationPrinter {
    private DocumentationPrinter() {
    }

    public static void main(String[] args) throws IOException {
        DocumentationPrinter.writePermissionsWikiTable();
    }

    private static void writePermissionsWikiTable() throws IOException {
        try (FileOutputStream fos = new FileOutputStream("wiki_permissions.md");){
            PrintStream stream = new PrintStream(fos);
            stream.print("## Overview\n");
            stream.print("This page is generated from the source. Click one of the edit buttons below to modify a command class. You will need to find the parts which correspond to the documentation. Command documentation will be consistent with what is available ingame");
            stream.println();
            stream.println();
            stream.print("To view this information ingame use `//help [category|command]`\n");
            stream.print("## Command Syntax     \n");
            stream.print(" - `<arg>` - A required parameter     \n");
            stream.print(" - `[arg]` - An optional parameter     \n");
            stream.print(" - `<arg1|arg2>` - Multiple parameters options     \n");
            stream.print(" - `<arg=value>` - Default or suggested value     \n");
            stream.print(" - `-a` - A command flag e.g. `//<command> -a [flag-value]`");
            stream.println();
            stream.print("## See also\n");
            stream.print(" - [Masks](https://github.com/boy0001/FastAsyncWorldedit/wiki/WorldEdit---FAWE-mask-list)\n");
            stream.print(" - [Patterns](https://github.com/boy0001/FastAsyncWorldedit/wiki/WorldEdit-and-FAWE-patterns)\n");
            stream.print(" - [Transforms](https://github.com/boy0001/FastAsyncWorldedit/wiki/Transforms)\n");
            stream.println();
            stream.print("## Content");
            stream.println();
            stream.print("Click on a category to go to the list of commands, or `More Info` for detailed descriptions ");
            stream.println();
            StringBuilder builder = new StringBuilder();
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/we ", WorldEditCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", UtilityCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", RegionCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", SelectionCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", HistoryCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/schematic ", SchematicCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", ClipboardCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", GenerationCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", BiomeCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/anvil ", AnvilCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/sp ", SuperPickaxeCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", NavigationCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/snapshot", SnapshotCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", SnapshotUtilCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", ScriptingCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", ChunkCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", OptionsCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/", BrushOptionsCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/tool ", ToolCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/brush ", BrushCommands.class);
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "", MaskCommands.class, "/Masks");
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "", PatternCommands.class, "/Patterns");
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "", TransformCommands.class, "/Transforms");
            DocumentationPrinter.writePermissionsWikiTable(stream, builder, "/cfi ", CFICommands.class, "Create From Image");
            stream.println();
            stream.print("#### Uncategorized\n");
            stream.append("| Aliases | Permission | flags | Usage |\n");
            stream.append("| --- | --- | --- | --- |\n");
            stream.append("| //cancel | fawe.cancel | | Cancels your current operations |\n");
            stream.append("| /plot replaceall | plots.replaceall | | Replace all blocks in the plot world |\n");
            stream.print("\n---\n");
            stream.print(builder);
        }
    }

    private static void writePermissionsWikiTable(PrintStream stream, StringBuilder content, String prefix, Class<?> cls) {
        DocumentationPrinter.writePermissionsWikiTable(stream, content, prefix, cls, DocumentationPrinter.getName(cls));
    }

    public static String getName(Class cls) {
        return cls.getSimpleName().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
    }

    private static void writePermissionsWikiTable(PrintStream stream, StringBuilder content, String prefix, Class<?> cls, String name) {
        stream.print(" - [`" + name + "`](#" + name.replaceAll(" ", "-").replaceAll("/", "").toLowerCase() + "-edittop) ");
        Command cmd = cls.getAnnotation(Command.class);
        if (cmd != null) {
            stream.print(" (" + cmd.desc() + ")");
        }
        stream.println();
        DocumentationPrinter.writePermissionsWikiTable(content, prefix, cls, name, true);
    }

    private static void writePermissionsWikiTable(StringBuilder stream, String prefix, Class<?> cls, String name, boolean title) {
        if (title) {
            String path = "https://github.com/boy0001/FastAsyncWorldedit/edit/master/core/src/main/java/" + cls.getName().replaceAll("\\.", "/") + ".java";
            stream.append("### **" + name + "** `[`[`edit`](" + path + ")`|`[`top`](#overview)`]`");
            stream.append("\n");
            Command cmd = cls.getAnnotation(Command.class);
            if (cmd != null) {
                if (!cmd.desc().isEmpty()) {
                    stream.append("> (" + cmd.desc() + ")    \n");
                }
                if (!cmd.help().isEmpty()) {
                    stream.append("" + cmd.help() + "    \n");
                }
            }
            stream.append("\n");
            stream.append("---");
            stream.append("\n");
            stream.append("\n");
        }
        for (Method method : cls.getMethods()) {
            Class<?>[] nestedClasses;
            if (!method.isAnnotationPresent(Command.class)) continue;
            Command cmd = method.getAnnotation(Command.class);
            String[] aliases = cmd.aliases();
            String usage = prefix + aliases[0] + " " + cmd.usage();
            if (!cmd.flags().isEmpty()) {
                for (char c : cmd.flags().toCharArray()) {
                    usage = usage + " [-" + c + "]";
                }
            }
            stream.append("#### `" + usage + "`\n");
            if (method.isAnnotationPresent(CommandPermissions.class)) {
                CommandPermissions perms = method.getAnnotation(CommandPermissions.class);
                stream.append("**Perm**: `" + StringMan.join(perms.value(), "`, `") + "`    \n");
            }
            String help = cmd.help() == null || cmd.help().isEmpty() ? cmd.desc() : cmd.help();
            stream.append("**Desc**: " + help.trim().replaceAll("\n", "<br />") + "    \n");
            if (!method.isAnnotationPresent(NestedCommand.class)) continue;
            NestedCommand nested = method.getAnnotation(NestedCommand.class);
            for (Class<?> clazz : nestedClasses = nested.value()) {
                DocumentationPrinter.writePermissionsWikiTable(stream, prefix + cmd.aliases()[0] + " ", clazz, DocumentationPrinter.getName(clazz), false);
            }
        }
        stream.append("\n");
        if (title) {
            stream.append("---");
        }
        stream.append("\n");
        stream.append("\n");
    }
}

