/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.brush.BrushSettings;
import com.boydti.fawe.util.ReflectionUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.entity.Player;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class BrushCache {
    private static final WeakHashMap<Object, BrushTool> brushCache = new WeakHashMap();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final ThreadLocal<Boolean> RECURSION = new ThreadLocal();

    private static final CompoundTag getNBT(BaseItem item) {
        return item.hasNbtData() ? item.getNbtData() : null;
    }

    private static final Object getKey(BaseItem item) {
        return item.getNativeItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final BrushTool getTool(Player player, LocalSession session, BaseItem item) {
        if (!item.hasNbtData()) {
            return null;
        }
        Object key = BrushCache.getKey(item);
        if (key == null) {
            return null;
        }
        BrushTool cached = brushCache.get(key);
        if (cached != null) {
            return cached;
        }
        CompoundTag nbt = item.getNbtData();
        if (nbt == null) {
            return null;
        }
        StringTag json = (StringTag)nbt.getValue().get("weBrushJson");
        if (json != null) {
            try {
                if (RECURSION.get() != null) {
                    BrushTool brushTool = null;
                    return brushTool;
                }
                RECURSION.set(true);
                BrushTool tool = BrushTool.fromString(player, session, json.getValue());
                tool.setHolder(item);
                brushCache.put(key, tool);
                BrushTool brushTool = tool;
                return brushTool;
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
                Fawe.debug("Invalid brush for " + player + " holding " + item.getType() + ": " + json.getValue());
                if (item != null) {
                    item.setNbtData(null);
                    brushCache.remove(key);
                }
            }
            finally {
                RECURSION.remove();
            }
        }
        return null;
    }

    public static BrushTool getCachedTool(BaseItem item) {
        Object key = BrushCache.getKey(item);
        if (key != null) {
            return brushCache.get(key);
        }
        return null;
    }

    public static final BrushTool setTool(BaseItem item, BrushTool tool) {
        Map map;
        if (item.getNativeItem() == null) {
            return null;
        }
        CompoundTag nbt = item.getNbtData();
        if (nbt == null) {
            if (tool == null) {
                return tool;
            }
            map = new HashMap<String, Tag>();
            nbt = new CompoundTag(map);
        } else {
            map = ReflectionUtils.getMap(nbt.getValue());
        }
        brushCache.remove(BrushCache.getKey(item));
        CompoundTag display = (CompoundTag)map.get("display");
        if (tool != null) {
            Map displayMap;
            String json = tool.toString(gson);
            map.put("weBrushJson", new StringTag(json));
            if (display == null) {
                displayMap = new HashMap<String, Tag>();
                map.put("display", new CompoundTag(displayMap));
            } else {
                displayMap = ReflectionUtils.getMap(display.getValue());
            }
            displayMap.put("Lore", FaweCache.asTag(json.split("\\r?\\n")));
            String primary = (String)tool.getPrimary().getSettings().get((Object)BrushSettings.SettingType.BRUSH);
            String secondary = (String)tool.getSecondary().getSettings().get((Object)BrushSettings.SettingType.BRUSH);
            if (primary == null) {
                primary = secondary;
            }
            if (secondary == null) {
                secondary = primary;
            }
            if (primary != null) {
                String name = primary == secondary ? primary.split(" ")[0] : primary.split(" ")[0] + " / " + secondary.split(" ")[0];
                displayMap.put("Name", new StringTag("{\"text\":\"" + name + "\"}"));
            }
        } else if (map.containsKey("weBrushJson")) {
            map.remove("weBrushJson");
            if (display != null) {
                Map displayMap = ReflectionUtils.getMap(display.getValue());
                displayMap.remove("Lore");
                displayMap.remove("Name");
                if (displayMap.isEmpty()) {
                    map.remove("display");
                }
            }
        } else {
            return tool;
        }
        item.setNbtData(nbt);
        if (tool != null) {
            brushCache.put(BrushCache.getKey(item), tool);
        }
        return tool;
    }
}

