/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.visitor;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.IntegerTrio;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DFSVisitor
implements Operation {
    private final RegionFunction function;
    private final List<Vector> directions = new ArrayList<Vector>();
    private final Map<Node, AtomicInteger> visited;
    private final ArrayDeque<NodePair> queue = new ArrayDeque();
    private final HashSet<Node> hashQueue = new LinkedHashSet<Node>();
    private final int maxDepth;
    private final int maxBranch;
    private int affected = 0;

    public DFSVisitor(RegionFunction function) {
        this(function, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public DFSVisitor(RegionFunction function, int maxDepth, int maxBranching) {
        this.visited = new LinkedHashMap<Node, AtomicInteger>();
        this.function = function;
        this.directions.add(new Vector(0, -1, 0));
        this.directions.add(new Vector(0, 1, 0));
        this.directions.add(new Vector(-1, 0, 0));
        this.directions.add(new Vector(1, 0, 0));
        this.directions.add(new Vector(0, 0, -1));
        this.directions.add(new Vector(0, 0, 1));
        this.maxDepth = maxDepth;
        this.maxBranch = maxBranching;
    }

    public abstract boolean isVisitable(Vector var1, Vector var2);

    public List<Vector> getDirections() {
        return this.directions;
    }

    private IntegerTrio[] getIntDirections() {
        IntegerTrio[] array = new IntegerTrio[this.directions.size()];
        for (int i = 0; i < array.length; ++i) {
            Vector dir = this.directions.get(i);
            array[i] = new IntegerTrio(dir.getBlockX(), dir.getBlockY(), dir.getBlockZ());
        }
        return array;
    }

    public void visit(Vector pos) {
        Node node = new Node(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
        if (!this.hashQueue.contains(node)) {
            this.isVisitable(pos, pos);
            this.queue.addFirst(new NodePair(null, node, 0));
            this.hashQueue.add(node);
        }
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        MutableBlockVector mutable = new MutableBlockVector();
        Vector mutable2 = new Vector();
        IntegerTrio[] dirs = this.getIntDirections();
        int layer = 0;
        while (!this.queue.isEmpty()) {
            NodePair current = this.queue.poll();
            Node from = current.to;
            this.hashQueue.remove(from);
            if (!this.visited.containsKey(from)) {
                mutable.mutX(from.getX());
                mutable.mutY(from.getY());
                mutable.mutZ(from.getZ());
                this.function.apply(mutable);
                int countAdd = 0;
                int countAttempt = 0;
                for (IntegerTrio direction : dirs) {
                    mutable2.mutX(from.getX() + direction.x);
                    mutable2.mutY(from.getY() + direction.y);
                    mutable2.mutZ(from.getZ() + direction.z);
                    if (!this.isVisitable(mutable, mutable2)) continue;
                    Node adjacent = new Node(mutable2.getBlockX(), mutable2.getBlockY(), mutable2.getBlockZ());
                    if (current.from != null && adjacent.equals(current.from)) continue;
                    AtomicInteger adjacentCount = this.visited.get(adjacent);
                    if (adjacentCount == null) {
                        if (countAdd++ < this.maxBranch) {
                            if (!this.hashQueue.contains(adjacent)) {
                                if (current.depth == this.maxDepth) {
                                    ++countAttempt;
                                    continue;
                                }
                                this.hashQueue.add(adjacent);
                                this.queue.addFirst(new NodePair(from, adjacent, current.depth + 1));
                                continue;
                            }
                            ++countAttempt;
                            continue;
                        }
                        ++countAttempt;
                        continue;
                    }
                    if (adjacentCount.decrementAndGet() == 0) {
                        this.visited.remove(adjacent);
                        continue;
                    }
                    if (!this.hashQueue.contains(adjacent)) continue;
                    ++countAttempt;
                }
                if (countAttempt > 0) {
                    this.visited.put(from, new AtomicInteger(countAttempt));
                }
                ++this.affected;
            }
            ++layer;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
        messages.add(BBC.VISITOR_BLOCK.format(this.getAffected()));
    }

    public int getAffected() {
        return this.affected;
    }

    public static final class Node {
        private int x;
        private int y;
        private int z;

        public Node(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private final void set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private final void set(Node node) {
            this.x = node.x;
            this.y = node.y;
            this.z = node.z;
        }

        public final int hashCode() {
            return this.x ^ this.z << 12 ^ this.y << 24;
        }

        private final int getX() {
            return this.x;
        }

        private final int getY() {
            return this.y;
        }

        private final int getZ() {
            return this.z;
        }

        public String toString() {
            return this.x + "," + this.y + "," + this.z;
        }

        public boolean equals(Object obj) {
            Node other = (Node)obj;
            return other.x == this.x && other.z == this.z && other.y == this.y;
        }
    }

    public class NodePair {
        public final Node to;
        public final Node from;
        private final int depth;

        public NodePair(Node from, Node to, int depth) {
            this.from = from;
            this.to = to;
            this.depth = depth;
        }
    }
}

