/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.pattern.PatternExtent;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class MaskedPattern
extends AbstractPattern {
    private final PatternExtent patternExtent;
    private final Pattern secondaryPattern;
    private Mask mask;

    public MaskedPattern(Mask mask, PatternExtent primary, Pattern secondary) {
        this.mask = mask;
        this.patternExtent = primary;
        this.secondaryPattern = secondary;
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        this.patternExtent.setTarget(position);
        if (this.mask.test(position)) {
            return this.patternExtent.getAndResetTarget();
        }
        return this.secondaryPattern.apply(position);
    }

    @Override
    public boolean apply(Extent extent, Vector set, Vector get) throws WorldEditException {
        this.patternExtent.setTarget(get);
        if (this.mask.test(get)) {
            return this.patternExtent.getAndResetTarget(extent, set, get);
        }
        return this.secondaryPattern.apply(extent, set, get);
    }
}

