/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask2D;
import javax.annotation.Nullable;

public class RadiusMask
extends AbstractMask
implements ResettableMask {
    private transient Vector pos;
    private final int minSqr;
    private final int maxSqr;

    public RadiusMask(int min, int max) {
        this.minSqr = min * min;
        this.maxSqr = max * max;
    }

    @Override
    public void reset() {
        this.pos = null;
    }

    @Override
    public boolean test(Vector to) {
        int dx;
        int d;
        if (this.pos == null) {
            this.pos = new MutableBlockVector(to);
        }
        if ((d = (dx = this.pos.getBlockX() - to.getBlockX()) * dx) > this.maxSqr) {
            return false;
        }
        int dz = this.pos.getBlockZ() - to.getBlockZ();
        if ((d += dz * dz) > this.maxSqr) {
            return false;
        }
        int dy = this.pos.getBlockY() - to.getBlockY();
        return (d += dy * dy) >= this.minSqr && d <= this.maxSqr;
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        return null;
    }
}

