/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class FastWorldEditExtent
extends AbstractDelegateExtent
implements HasFaweQueue {
    private final World world;
    private FaweQueue queue;
    private final int maxY;

    public FastWorldEditExtent(World world, FaweQueue queue) {
        super(queue);
        this.world = world;
        this.queue = queue;
        this.maxY = world.getMaxY();
    }

    @Override
    public FaweQueue getQueue() {
        return this.queue;
    }

    @Override
    public int getMaxY() {
        return this.queue.getMaxY();
    }

    @Override
    public int getLight(int x, int y, int z) {
        return this.queue.getLight(x, y, z);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.queue.getEmmittedLight(x, y, z);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.queue.getSkyLight(x, y, z);
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        return this.queue.getBrightness(x, y, z);
    }

    @Override
    public int getOpacity(int x, int y, int z) {
        return this.queue.getOpacity(x, y, z);
    }

    @Override
    public Entity createEntity(Location loc, BaseEntity entity) {
        if (entity != null) {
            HashMap<String, Tag> map;
            CompoundTag tag = entity.getNbtData();
            if (tag == null) {
                map = new HashMap();
                tag = new CompoundTag(map);
            }
            map = ReflectionUtils.getMap(tag.getValue());
            map.put("Id", new StringTag(entity.getType().getId()));
            ListTag pos = (ListTag)map.get("Pos");
            if (pos == null) {
                map.put("Pos", new ListTag<DoubleTag>(DoubleTag.class, Arrays.asList(new DoubleTag(loc.getX()), new DoubleTag(loc.getY()), new DoubleTag(loc.getZ()))));
            } else {
                List posList = ReflectionUtils.getList(pos.getValue());
                posList.set(0, new DoubleTag(loc.getX()));
                posList.set(1, new DoubleTag(loc.getY()));
                posList.set(2, new DoubleTag(loc.getZ()));
            }
            ListTag rot = (ListTag)map.get("Rotation");
            if (rot == null) {
                map.put("Rotation", new ListTag<Tag>(FloatTag.class, Arrays.asList(new FloatTag(loc.getYaw()), new DoubleTag(loc.getPitch()))));
            }
            this.queue.setEntity(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), tag);
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this.queue + "(" + this.getExtent() + ")";
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return FaweCache.CACHE_BIOME[this.queue.getBiomeId(position.getBlockX(), position.getBlockZ())];
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ(), block);
    }

    @Override
    public BlockState getLazyBlock(Vector location) {
        return this.getLazyBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        CompoundTag tile;
        int combinedId4Data = this.queue.getCombinedId4Data(x, y, z, 0);
        BlockTypes type = BlockTypes.getFromStateId(combinedId4Data);
        BlockState state = type.withStateId(combinedId4Data);
        if (type.getMaterial().hasContainer() && (tile = this.queue.getTileEntity(x, y, z)) != null) {
            return new BaseBlock(state, tile);
        }
        return state;
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.world.getEntities();
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.world.getEntities(region);
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.getLazyBlock(position);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        this.queue.setBiome(position.getBlockX(), position.getBlockZ(), biome);
        return true;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return this.queue.setBlock(x, y, z, block);
    }
}

