/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.object.changeset.AbstractDelegateChangeSet;
import com.boydti.fawe.object.changeset.FaweChangeSet;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.extent.inventory.BlockBagException;
import com.sk89q.worldedit.extent.inventory.UnplaceableBlockException;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class BlockBagChangeSet
extends AbstractDelegateChangeSet {
    private final boolean mine;
    private int[] missingBlocks = new int[BlockTypes.size()];
    private BlockBag blockBag;

    public BlockBagChangeSet(FaweChangeSet parent, BlockBag blockBag, boolean mine) {
        super(parent);
        this.blockBag = blockBag;
        this.mine = mine;
    }

    @Nullable
    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(@Nullable BlockBag blockBag) {
        this.blockBag = blockBag;
    }

    public Map<BlockType, Integer> popMissing() {
        HashMap<BlockType, Integer> map = new HashMap<BlockType, Integer>();
        for (int i = 0; i < this.missingBlocks.length; ++i) {
            int count = this.missingBlocks[i];
            if (count <= 0) continue;
            map.put(BlockTypes.get(i), count);
        }
        Arrays.fill(this.missingBlocks, 0);
        return map;
    }

    @Override
    public void add(Vector loc, BlockStateHolder from, BlockStateHolder to) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        this.add(x, y, z, from, to);
    }

    @Override
    public void add(int x, int y, int z, BlockStateHolder from, BlockStateHolder to) {
        this.check(from.getBlockType(), to.getBlockType());
        super.add(x, y, z, from, to);
    }

    public void check(BlockType typeFrom, BlockType typeTo) {
        if (!typeTo.getMaterial().isAir()) {
            try {
                this.blockBag.fetchPlacedBlock(typeTo.getDefaultState());
            }
            catch (UnplaceableBlockException e) {
                throw new FaweException.FaweBlockBagException();
            }
            catch (BlockBagException e) {
                int n = typeTo.getInternalId();
                this.missingBlocks[n] = this.missingBlocks[n] + 1;
                throw new FaweException.FaweBlockBagException();
            }
        }
        if (this.mine && !typeFrom.getMaterial().isAir()) {
            try {
                this.blockBag.storeDroppedBlock(typeFrom.getDefaultState());
            }
            catch (BlockBagException blockBagException) {
                // empty catch block
            }
        }
    }

    @Override
    public void add(int x, int y, int z, int combinedFrom, int combinedTo) {
        BlockTypes typeFrom = BlockTypes.getFromStateId(combinedFrom);
        BlockTypes typeTo = BlockTypes.getFromStateId(combinedTo);
        this.check(typeFrom, typeTo);
        super.add(x, y, z, combinedFrom, combinedTo);
    }

    @Override
    public void addTileCreate(CompoundTag nbt) {
        if (nbt.containsKey("items")) {
            Map map = ReflectionUtils.getMap(nbt.getValue());
            map.remove("items");
        }
        super.addTileCreate(nbt);
    }
}

