/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.sweep;

import com.boydti.fawe.object.brush.sweep.Spline;
import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.interpolation.Interpolation;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.RoundedTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;

public class ClipboardSpline
extends Spline {
    private final Transform transform;
    private ClipboardHolder clipboardHolder;
    private Vector originalOrigin;
    private Transform originalTransform;
    private Vector center;
    private Vector centerOffset;
    private LocalBlockVectorSet buffer;

    public ClipboardSpline(EditSession editSession, ClipboardHolder clipboardHolder, Interpolation interpolation) {
        this(editSession, clipboardHolder, interpolation, new AffineTransform(), -1);
    }

    public ClipboardSpline(EditSession editSession, ClipboardHolder clipboardHolder, Interpolation interpolation, Transform transform, int nodeCount) {
        super(editSession, interpolation, nodeCount);
        this.clipboardHolder = clipboardHolder;
        this.originalTransform = clipboardHolder.getTransform();
        Clipboard clipboard = clipboardHolder.getClipboard();
        this.originalOrigin = clipboard.getOrigin();
        Region region = clipboard.getRegion();
        Vector origin = clipboard.getOrigin();
        this.center = region.getCenter().setY(origin.getY() - 1.0);
        this.centerOffset = this.center.subtract(this.center.round());
        this.center = this.center.subtract(this.centerOffset);
        this.transform = transform;
        this.buffer = new LocalBlockVectorSet();
    }

    @Override
    protected int pasteBlocks(Vector target, Vector offset, double angle) throws MaxChangedBlocksException {
        RoundedTransform transform = new RoundedTransform(new AffineTransform().translate(offset).rotateY(angle));
        if (!this.transform.isIdentity()) {
            transform = transform.combine(this.transform);
        }
        if (!this.originalTransform.isIdentity()) {
            transform = transform.combine(this.originalTransform);
        }
        Clipboard clipboard = this.clipboardHolder.getClipboard();
        clipboard.setOrigin(this.center.subtract(this.centerOffset).round());
        this.clipboardHolder.setTransform(transform);
        Vector functionOffset = target.subtract(clipboard.getOrigin());
        int offX = functionOffset.getBlockX();
        int offY = functionOffset.getBlockY();
        int offZ = functionOffset.getBlockZ();
        Operation operation = this.clipboardHolder.createPaste(this.editSession).to(target).ignoreAirBlocks(true).filter(v -> this.buffer.add(v.getBlockX() + offX, v.getBlockY() + offY, v.getBlockZ() + offZ)).build();
        Operations.completeLegacy(operation);
        this.clipboardHolder.setTransform(this.originalTransform);
        clipboard.setOrigin(this.originalOrigin);
        return operation instanceof ForwardExtentCopy ? ((ForwardExtentCopy)operation).getAffected() : 0;
    }
}

