/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.changeset.FaweChangeSet;
import com.boydti.fawe.object.queue.DelegateFaweQueue;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockTypes;

public class ChangeSetFaweQueue
extends DelegateFaweQueue {
    private FaweChangeSet set;

    public ChangeSetFaweQueue(FaweChangeSet set, FaweQueue parent) {
        super(parent);
        this.set = set;
    }

    public FaweChangeSet getChangeSet() {
        return this.set;
    }

    public void setChangeSet(FaweChangeSet set) {
        this.set = set;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int combinedId) {
        if (super.setBlock(x, y, z, combinedId)) {
            CompoundTag nbt;
            int combinedFrom = this.getParent().getCombinedId4Data(x, y, z);
            BlockTypes typeFrom = BlockTypes.getFromStateId(combinedFrom);
            if (typeFrom.getMaterial().hasContainer() && (nbt = this.getParent().getTileEntity(x, y, z)) != null) {
                this.set.addTileRemove(nbt);
            }
            this.set.add(x, y, z, combinedFrom, combinedId);
            return true;
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int z, BaseBiome biome) {
        int oldBiome;
        if (super.setBiome(x, z, biome) && (oldBiome = this.getParent().getBiomeId(x, z)) != biome.getId()) {
            this.set.addBiomeChange(x, z, FaweCache.getBiome(oldBiome), biome);
            return true;
        }
        return false;
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tag) {
        super.setTile(x, y, z, tag);
        this.set.addTileCreate(tag);
    }

    @Override
    public void setEntity(int x, int y, int z, CompoundTag tag) {
        super.setEntity(x, y, z, tag);
        this.set.addEntityCreate(tag);
    }
}

