/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.command;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.jnbt.anvil.MCAClipboard;
import com.boydti.fawe.jnbt.anvil.MCAFile;
import com.boydti.fawe.jnbt.anvil.MCAFilter;
import com.boydti.fawe.jnbt.anvil.MCAFilterCounter;
import com.boydti.fawe.jnbt.anvil.MCAQueue;
import com.boydti.fawe.jnbt.anvil.filters.DebugFixAir;
import com.boydti.fawe.jnbt.anvil.filters.DebugFixP2Roads;
import com.boydti.fawe.jnbt.anvil.filters.DeleteBiomeFilterSimple;
import com.boydti.fawe.jnbt.anvil.filters.DeleteOldFilter;
import com.boydti.fawe.jnbt.anvil.filters.DeleteUnclaimedFilter;
import com.boydti.fawe.jnbt.anvil.filters.DeleteUninhabitedFilter;
import com.boydti.fawe.jnbt.anvil.filters.PlotTrimFilter;
import com.boydti.fawe.jnbt.anvil.filters.RemapFilter;
import com.boydti.fawe.jnbt.anvil.filters.RemoveLayerFilter;
import com.boydti.fawe.jnbt.anvil.filters.SetPatternFilter;
import com.boydti.fawe.jnbt.anvil.filters.TrimAirFilter;
import com.boydti.fawe.jnbt.anvil.history.IAnvilHistory;
import com.boydti.fawe.jnbt.anvil.history.NullAnvilHistory;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal4;
import com.boydti.fawe.object.changeset.AnvilHistory;
import com.boydti.fawe.object.clipboard.remap.ClipboardRemapper;
import com.boydti.fawe.object.number.MutableLong;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.SetQueue;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.function.Consumer;

@Command(aliases={"/anvil"}, desc="Manipulate billions of blocks: [More Info](https://github.com/boy0001/FastAsyncWorldedit/wiki/Anvil-API)")
public class AnvilCommands {
    private final WorldEdit worldEdit;

    public AnvilCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Deprecated
    public static <G, T extends MCAFilter<G>> T runWithWorld(Player player, String folder, T filter, boolean force) {
        return AnvilCommands.runWithWorld(player, folder, filter, force, false);
    }

    @Deprecated
    public static <G, T extends MCAFilter<G>> T runWithWorld(Player player, String folder, T filter, boolean force, boolean unsafe) {
        boolean copy = false;
        if (FaweAPI.getWorld(folder) != null) {
            if (!force) {
                BBC.WORLD_IS_LOADED.send(player, new Object[0]);
                return null;
            }
            copy = true;
        }
        FaweQueue defaultQueue = SetQueue.IMP.getNewQueue(folder, true, false);
        MCAQueue queue = new MCAQueue(defaultQueue);
        if (copy && !unsafe) {
            return queue.filterCopy(filter, RegionWrapper.GLOBAL());
        }
        return queue.filterWorld(filter);
    }

    @Deprecated
    public static <G, T extends MCAFilter<G>> T runWithSelection(Player player, EditSession editSession, Region selection, T filter) {
        if (!(selection instanceof CuboidRegion)) {
            BBC.NO_REGION.send(player, new Object[0]);
            return null;
        }
        CuboidRegion cuboid = (CuboidRegion)selection;
        RegionWrapper wrappedRegion = new RegionWrapper(cuboid.getMinimumPoint(), cuboid.getMaximumPoint());
        String worldName = Fawe.imp().getWorldName(editSession.getWorld());
        FaweQueue tmp = SetQueue.IMP.getNewQueue(worldName, true, false);
        MCAQueue queue = new MCAQueue(tmp);
        FawePlayer fp = FawePlayer.wrap(player);
        fp.checkAllowedRegion(selection);
        AnvilCommands.recordHistory(fp, editSession.getWorld(), iAnvilHistory -> queue.filterCopy(filter, wrappedRegion, (IAnvilHistory)iAnvilHistory));
        return filter;
    }

    public static void recordHistory(FawePlayer fp, World world, Consumer<IAnvilHistory> run) {
        LocalSession session = fp.getSession();
        if (session == null || session.hasFastMode()) {
            run.accept(new NullAnvilHistory());
        } else {
            AnvilHistory history = new AnvilHistory(Fawe.imp().getWorldName(world), fp.getUUID());
            run.accept(history);
            session.remember(fp.getPlayer(), world, history, fp.getLimit());
        }
    }

    @Command(aliases={"replaceall", "rea", "repall"}, usage="<folder> [from-block] <to-block>", desc="Replace all blocks in the selection with another", help="Replace all blocks in the selection with another\nThe -d flag disabled wildcard data matching\n", flags="df", min=2, max=4)
    @CommandPermissions(value={"worldedit.anvil.replaceall"})
    public void replaceAll(Player player, String folder, @Optional String from, String to, @Switch(value=100) boolean useData) throws WorldEditException {
    }

    @Command(aliases={"remapall"}, usage="<folder>", help="Remap the world between MCPE/PC values", desc="Remap the world between MCPE/PC values", min=1, max=1)
    @CommandPermissions(value={"worldedit.anvil.remapall"})
    public void remapall(Player player, String folder) throws WorldEditException {
        ClipboardRemapper.RemapPlatform to;
        ClipboardRemapper.RemapPlatform from;
        if (Fawe.imp().getPlatform().equalsIgnoreCase("nukkit")) {
            from = ClipboardRemapper.RemapPlatform.PC;
            to = ClipboardRemapper.RemapPlatform.PE;
        } else {
            from = ClipboardRemapper.RemapPlatform.PE;
            to = ClipboardRemapper.RemapPlatform.PC;
        }
        RemapFilter filter = new RemapFilter(from, to);
        RemapFilter result = AnvilCommands.runWithWorld(player, folder, filter, true);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"deleteallunvisited", "delunvisited"}, usage="<folder> <age-ticks> [file-age=60000]", desc="Delete all chunks which haven't been occupied", help="Delete all chunks which haven't been occupied for `age-ticks` (20t = 1s) and \nHave not been accessed since `file-duration` (ms) after creation and\nHave not been used in the past `chunk-inactivity` (ms)The auto-save interval is the recommended value for `file-duration` and `chunk-inactivity`", min=2, max=3)
    @CommandPermissions(value={"worldedit.anvil.deleteallunvisited"})
    public void deleteAllUnvisited(Player player, String folder, int inhabitedTicks, @Optional(value={"60000"}) int fileDurationMillis) throws WorldEditException {
        long chunkInactivityMillis = fileDurationMillis;
        DeleteUninhabitedFilter filter = new DeleteUninhabitedFilter(fileDurationMillis, inhabitedTicks, chunkInactivityMillis);
        DeleteUninhabitedFilter result = AnvilCommands.runWithWorld(player, folder, filter, true);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"deleteallunclaimed", "delallunclaimed"}, usage="<age-ticks> [file-age=60000]", desc="(Supports: WG, P2, GP) Delete all chunks which haven't been occupied AND claimed", help="(Supports: WG, P2, GP) Delete all chunks which aren't claimed AND haven't been occupied for `age-ticks` (20t = 1s) and \nHave not been accessed since `file-duration` (ms) after creation and\nHave not been used in the past `chunk-inactivity` (ms)The auto-save interval is the recommended value for `file-duration` and `chunk-inactivity`", min=1, max=3)
    @CommandPermissions(value={"worldedit.anvil.deleteallunclaimed"})
    public void deleteAllUnclaimed(Player player, int inhabitedTicks, @Optional(value={"60000"}) int fileDurationMillis, @Switch(value=100) boolean debug) throws WorldEditException {
        DeleteUnclaimedFilter result;
        String folder = Fawe.imp().getWorldName(player.getWorld());
        long chunkInactivityMillis = fileDurationMillis;
        DeleteUnclaimedFilter filter = new DeleteUnclaimedFilter(player.getWorld(), fileDurationMillis, inhabitedTicks, chunkInactivityMillis);
        if (debug) {
            filter.enableDebug();
        }
        if ((result = AnvilCommands.runWithWorld(player, folder, filter, true)) != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"deleteunclaimed"}, usage="<age-ticks> [file-age=60000]", desc="(Supports: WG, P2, GP) Delete all chunks which haven't been occupied AND claimed", help="(Supports: WG, P2, GP) Delete all chunks which aren't claimed AND haven't been occupied for `age-ticks` (20t = 1s) and \nHave not been accessed since `file-duration` (ms) after creation and\nHave not been used in the past `chunk-inactivity` (ms)The auto-save interval is the recommended value for `file-duration` and `chunk-inactivity`", min=1, max=3)
    @CommandPermissions(value={"worldedit.anvil.deleteunclaimed"})
    public void deleteUnclaimed(Player player, EditSession editSession, @Selection Region selection, int inhabitedTicks, @Optional(value={"60000"}) int fileDurationMillis, @Switch(value=100) boolean debug) throws WorldEditException {
        DeleteUnclaimedFilter result;
        String folder = Fawe.imp().getWorldName(player.getWorld());
        long chunkInactivityMillis = fileDurationMillis;
        DeleteUnclaimedFilter filter = new DeleteUnclaimedFilter(player.getWorld(), fileDurationMillis, inhabitedTicks, chunkInactivityMillis);
        if (debug) {
            filter.enableDebug();
        }
        if ((result = AnvilCommands.runWithSelection(player, editSession, selection, filter)) != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"deletealloldregions", "deloldreg"}, usage="<folder> <time>", desc="Delete regions which haven't been accessed in a certain amount of time", help="Delete regions which haven't been accessed in a certain amount of time\nYou can use seconds (s), minutes (m), hours (h), days (d), weeks (w), years (y)\n(months are not a unit of time)\nE.g. 8h5m12s\n", min=2, max=3)
    @CommandPermissions(value={"worldedit.anvil.deletealloldregions"})
    public void deleteAllOldRegions(Player player, String folder, String time) throws WorldEditException {
        long duration = MainUtil.timeToSec(time) * 1000L;
        DeleteOldFilter filter = new DeleteOldFilter(duration);
        DeleteOldFilter result = AnvilCommands.runWithWorld(player, folder, filter, true);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"trimallplots"}, desc="Trim chunks in a Plot World", help="Trim chunks in a Plot World\nUnclaimed chunks will be deleted\nUnmodified chunks will be deleted\nUse -v to also delete unvisited chunks\n")
    @CommandPermissions(value={"worldedit.anvil.trimallplots"})
    public void trimAllPlots(Player player, @Switch(value=118) boolean deleteUnvisited) throws WorldEditException {
        String folder = Fawe.imp().getWorldName(player.getWorld());
        int visitTime = deleteUnvisited ? 1 : -1;
        PlotTrimFilter filter = new PlotTrimFilter(player.getWorld(), 0L, visitTime, 600000L);
        FaweQueue defaultQueue = SetQueue.IMP.getNewQueue(folder, true, false);
        MCAQueue queue = new MCAQueue(defaultQueue);
        PlotTrimFilter result = queue.filterWorld(filter);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"deletebiomechunks"}, desc="Delete chunks matching a specific biome")
    @CommandPermissions(value={"worldedit.anvil.trimallair"})
    public void deleteBiome(Player player, String folder, BaseBiome biome, @Switch(value=117) boolean unsafe) {
        DeleteBiomeFilterSimple filter = new DeleteBiomeFilterSimple(biome);
        DeleteBiomeFilterSimple result = AnvilCommands.runWithWorld(player, folder, filter, true, unsafe);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"trimallair"}, desc="Trim all air in the world")
    @CommandPermissions(value={"worldedit.anvil.trimallair"})
    public void trimAllAir(Player player, String folder, @Switch(value=117) boolean unsafe) throws WorldEditException {
        TrimAirFilter filter = new TrimAirFilter();
        TrimAirFilter result = AnvilCommands.runWithWorld(player, folder, filter, true, unsafe);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"debugfixair"}, desc="debug - do not use")
    @CommandPermissions(value={"worldedit.anvil.debugfixair"})
    public void debugfixair(Player player, String folder) throws WorldEditException {
        DebugFixAir filter = new DebugFixAir();
        DebugFixAir result = AnvilCommands.runWithWorld(player, folder, filter, true, true);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"debugfixroads"}, desc="debug - do not use")
    @CommandPermissions(value={"worldedit.anvil.debugfixroads"})
    public void debugfixroads(Player player, String folder) throws WorldEditException {
        DebugFixP2Roads filter = new DebugFixP2Roads();
        DebugFixP2Roads result = AnvilCommands.runWithWorld(player, folder, filter, true, true);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"replaceallpattern", "reap", "repallpat"}, usage="<folder> [from-block] <to-pattern>", desc="Replace all blocks in the selection with another", flags="dm", min=2, max=4)
    @CommandPermissions(value={"worldedit.anvil.replaceall"})
    public void replaceAllPattern(Player player, String folder, @Optional String from, Pattern to, @Switch(value=100) boolean useData, @Switch(value=109) boolean useMap) throws WorldEditException {
    }

    @Command(aliases={"countall"}, usage="<folder> [hasSky] <id>", desc="Count all blocks in a world", flags="d", min=2, max=3)
    @CommandPermissions(value={"worldedit.anvil.countall"})
    public void countAll(Player player, EditSession editSession, String folder, String arg, @Switch(value=100) boolean useData) throws WorldEditException {
    }

    @Command(aliases={"clear", "unset"}, desc="Clear the chunks in a selection (delete without defrag)")
    @CommandPermissions(value={"worldedit.anvil.clear"})
    public void unset(Player player, EditSession editSession, @Selection Region selection) throws WorldEditException {
        Vector top;
        Vector bot = selection.getMinimumPoint();
        final RegionWrapper region = new RegionWrapper(bot, top = selection.getMaximumPoint());
        MCAFilterCounter filter = new MCAFilterCounter(){

            @Override
            public MCAFile applyFile(MCAFile file) {
                int X = file.getX();
                int Z = file.getZ();
                final int bcx = X << 5;
                final int bcz = Z << 5;
                int bx = X << 9;
                int bz = Z << 9;
                if (region.isIn(bx, bz) && region.isIn(bx + 511, bz + 511)) {
                    file.setDeleted(true);
                    ((MutableLong)this.get()).add(0x4000000L);
                } else if (region.isInMCA(X, Z)) {
                    file.init();
                    final byte[] empty = new byte[4];
                    final RandomAccessFile raf = file.getRandomAccessFile();
                    file.forEachChunk(new RunnableVal4<Integer, Integer, Integer, Integer>(){

                        @Override
                        public void run(Integer cx, Integer cz, Integer offset, Integer size) {
                            if (region.isInChunk(bcx + cx, bcz + cz)) {
                                int index = ((cx & 0x1F) << 2) + ((cz & 0x1F) << 7);
                                try {
                                    raf.seek(index);
                                    raf.write(empty);
                                    ((MutableLong)this.get()).add(65536L);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                    file.clear();
                }
                return null;
            }
        };
        MCAFilterCounter result = AnvilCommands.runWithSelection(player, editSession, selection, filter);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"count"}, usage="<ids>", desc="Count blocks in a selection", flags="d", min=1, max=2)
    @CommandPermissions(value={"worldedit.anvil.count"})
    public void count(Player player, EditSession editSession, @Selection Region selection, String arg, @Switch(value=100) boolean useData) throws WorldEditException {
    }

    @Command(aliases={"distr"}, desc="Replace all blocks in the selection with another")
    @CommandPermissions(value={"worldedit.anvil.distr"})
    public void distr(Player player, EditSession editSession, @Selection Region selection, @Switch(value=100) boolean useData) throws WorldEditException {
    }

    @Command(aliases={"replace", "r"}, usage="[from-block] <to-block>", desc="Replace all blocks in the selection with another")
    @CommandPermissions(value={"worldedit.anvil.replace"})
    public void replace(Player player, EditSession editSession, @Selection Region selection, @Optional String from, String to, @Switch(value=100) boolean useData) throws WorldEditException {
    }

    @Command(aliases={"replacepattern", "preplace", "rp"}, usage="[from-mask] <to-pattern>", desc="Replace all blocks in the selection with a pattern")
    @CommandPermissions(value={"worldedit.anvil.replace"})
    public void replacePattern(Player player, EditSession editSession, @Selection Region selection, @Optional String from, Pattern to, @Switch(value=100) boolean useData, @Switch(value=109) boolean useMap) throws WorldEditException {
    }

    @Command(aliases={"set"}, usage="<to-pattern>", desc="Set all blocks in the selection with a pattern")
    @CommandPermissions(value={"worldedit.anvil.set"})
    public void set(Player player, EditSession editSession, @Selection Region selection, Pattern to) throws WorldEditException {
        SetPatternFilter filter = new SetPatternFilter(to);
        MCAFilterCounter result = AnvilCommands.runWithSelection(player, editSession, selection, filter);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"removelayers"}, usage="<id>", desc="Removes matching chunk layers", help="Remove if all the selected layers in a chunk match the provided id")
    @CommandPermissions(value={"worldedit.anvil.removelayer"})
    public void removeLayers(Player player, EditSession editSession, @Selection Region selection, int id) throws WorldEditException {
        int maxY;
        Vector min = selection.getMinimumPoint();
        Vector max = selection.getMaximumPoint();
        int minY = min.getBlockY();
        RemoveLayerFilter filter = new RemoveLayerFilter(minY, maxY = max.getBlockY(), id);
        MCAFilterCounter result = AnvilCommands.runWithSelection(player, editSession, selection, filter);
        if (result != null) {
            player.print(BBC.getPrefix() + BBC.VISITOR_BLOCK.format(result.getTotal()));
        }
    }

    @Command(aliases={"copy"}, desc="Lazily copy chunks to your anvil clipboard")
    @CommandPermissions(value={"worldedit.anvil.copychunks"})
    public void copy(Player player, LocalSession session, EditSession editSession, @Selection Region selection) throws WorldEditException {
        if (!(selection instanceof CuboidRegion)) {
            BBC.NO_REGION.send(player, new Object[0]);
            return;
        }
        CuboidRegion cuboid = (CuboidRegion)selection;
        String worldName = Fawe.imp().getWorldName(editSession.getWorld());
        FaweQueue tmp = SetQueue.IMP.getNewQueue(worldName, true, false);
        MCAQueue queue = new MCAQueue(tmp);
        Vector origin = session.getPlacementPosition(player);
        MCAClipboard clipboard = new MCAClipboard(queue, cuboid, origin);
        FawePlayer fp = FawePlayer.wrap(player);
        fp.setMeta("anvil-clipboard", clipboard);
        BBC.COMMAND_COPY.send(player, selection.getArea());
    }

    @Command(aliases={"paste"}, desc="Paste chunks from your anvil clipboard", help="Paste the chunks from your anvil clipboard.\nThe -c flag will align the paste to the chunks.", flags="c")
    @CommandPermissions(value={"worldedit.anvil.pastechunks"})
    public void paste(Player player, LocalSession session, EditSession editSession, @Switch(value=99) boolean alignChunk) throws WorldEditException, IOException {
    }
}

