/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.listener;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.brush.MovableTool;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.scroll.ScrollTool;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.command.tool.Tool;
import com.sk89q.worldedit.entity.Player;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class BrushListener
implements Listener {
    public BrushListener(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerItemHoldEvent(PlayerItemHeldEvent event) {
        int oldSlot;
        int slot;
        int ri;
        ScrollTool scrollable;
        org.bukkit.entity.Player bukkitPlayer = event.getPlayer();
        if (bukkitPlayer.isSneaking()) {
            return;
        }
        FawePlayer fp = FawePlayer.wrap(bukkitPlayer);
        Player player = fp.getPlayer();
        LocalSession session = fp.getSession();
        Tool tool = session.getTool(player);
        if (tool instanceof ScrollTool && (scrollable = (ScrollTool)((Object)tool)).increment(player, ri = (slot = event.getNewSlot()) - (oldSlot = event.getPreviousSlot()) <= 4 && slot - oldSlot > 0 || slot - oldSlot < -4 ? 1 : -1)) {
            if (Settings.IMP.EXPERIMENTAL.PERSISTENT_BRUSHES) {
                bukkitPlayer.getInventory().setHeldItemSlot(oldSlot);
            } else {
                PlayerInventory inv = bukkitPlayer.getInventory();
                ItemStack item = inv.getItem(slot);
                ItemStack newItem = inv.getItem(oldSlot);
                inv.setItem(slot, newItem);
                inv.setItem(oldSlot, item);
                bukkitPlayer.updateInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getYaw() != to.getYaw() && from.getPitch() != to.getPitch() || from.getBlockX() != to.getBlockX() || from.getBlockZ() != to.getBlockZ() || from.getBlockY() != to.getBlockY()) {
            org.bukkit.entity.Player bukkitPlayer = event.getPlayer();
            FawePlayer fp = FawePlayer.wrap(bukkitPlayer);
            Player player = fp.getPlayer();
            LocalSession session = fp.getSession();
            Tool tool = session.getTool(player);
            if (tool != null && tool instanceof MovableTool) {
                ((MovableTool)((Object)tool)).move(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        org.bukkit.entity.Player bukkitPlayer = event.getPlayer();
        if (bukkitPlayer.isSneaking()) {
            if (event.getAction() == Action.PHYSICAL) {
                return;
            }
            FawePlayer fp = FawePlayer.wrap(bukkitPlayer);
            Player player = fp.getPlayer();
            LocalSession session = fp.getSession();
            Tool tool = session.getTool(player);
            if (tool instanceof ResettableTool && ((ResettableTool)((Object)tool)).reset()) {
                event.setCancelled(true);
            }
        }
    }
}

