/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe;

public class FaweVersion {
    public final int year;
    public final int month;
    public final int day;
    public final int hash;
    public final int build;
    public final int major;
    public final int minor;
    public final int patch;

    public FaweVersion(String version) {
        String[] split = version.substring(version.indexOf(61) + 1).split("-");
        if (split[0].equals("unknown")) {
            this.patch = 0;
            this.minor = 0;
            this.major = 0;
            this.build = 0;
            this.hash = 0;
            this.day = 0;
            this.month = 0;
            this.year = 0;
            return;
        }
        String[] date = split[0].split("\\.");
        this.year = Integer.parseInt(date[0]);
        this.month = Integer.parseInt(date[1]);
        this.day = Integer.parseInt(date[2]);
        this.hash = Integer.parseInt(split[1], 16);
        this.build = Integer.parseInt(split[2]);
        String[] semver = split[3].split("\\.");
        this.major = Integer.parseInt(semver[0]);
        this.minor = Integer.parseInt(semver[1]);
        this.patch = Integer.parseInt(semver[2]);
    }

    public String toString() {
        return "FastAsyncWorldEdit-" + this.year + "." + this.month + "." + this.day + "-" + Integer.toHexString(this.hash) + "-" + this.build;
    }

    public boolean isNewer(FaweVersion other) {
        return other.build < this.build && (this.major > other.major || this.major == other.major && this.minor > other.minor || this.major == other.major && this.minor == other.minor && this.patch > other.patch);
    }
}

